## Flow

You can create a simple app with the following code:

```Python 
from tensorpc.flow import mui, three, plus, appctx, mark_create_layout, flowui
class App:
    
    class Config(plus.AppInMemory.Config):
        is_horizontal = False
        height = "800px"

    @mark_create_layout
    def my_layout(self):
        nodes = [
            flowui.Node(id="1", type="input", data=flowui.NodeData(label="Right Click On Pane!"), position=flowui.XYPosition(0, 0)),
        ]
        items = [
            mui.MenuItem(id="input", label="Add Input Node"),
            mui.MenuItem(id="output", label="Add Output Node"),
            mui.MenuItem(id="default", label="Add Default Node"),
        ]
        graph = flowui.Flow(nodes, [], [
            flowui.MiniMap(),
            flowui.Controls(),
            flowui.Background()
        ]).prop(paneContextMenuItems=items)
        graph.event_pane_context_menu.on(self.add_node)
        self.graph = graph
        return mui.HBox([
            graph,
        ]).prop(width="100%", height="100%", overflow="hidden")

    async def add_node(self, data):
        item_id = data["itemId"]
        mouse_x = data["clientOffset"]["x"]
        mouse_y = data["clientOffset"]["y"]
        node_type = item_id
        new_node = flowui.Node(type=node_type, id=self.graph.create_unique_node_id("node"), data=flowui.NodeData(label=node_type), 
            position=flowui.XYPosition(mouse_x, mouse_y))
        # screen_to_flow: convert screen position (mouse xy) to flowui position
        await self.graph.add_node(new_node, screen_to_flow=True)

```

